
***********************************************************************************************
***     ANALYSIS: "Stable relationships, stable participation?"			      				***
***		DATA:  - Pairfam waves 1 to 6, Release 6.0	 								   	 	***
***			   - Paradata waves 3 to 7 (available upon request) 					     	***
***																				   		 	***	
*** 	CONTENT: Section 4.3 Effects of a change toward relationship instability 	   	 	***												   				   ***
***		       - Sample: two consecutive observations with same partner prior to wave t		***	
***			   - Additional variables for analyses based on restricted sample				***
***		       - Effects on participation (models 8 & 9, Figure 3; Appendix Table A3) 		***
***		       - Effects on contact & cooperation (models 10-13, Figure 4; Table A4)	   	***
***********************************************************************************************

clear all
set maxvar 10000
set more off
set varabbrev off

global path1 `""datapath""' 
cd $path1	

use attrition_restr.dta, clear

sort id waveb

*** Sample: respondents with two consecutive observations with same partner in waves t-1 and t-2; adult respondents

count if hp==1 & pid==.
drop if pid==. 	// drop observations without partner

gen sample2=0
bysort id (waveb): replace sample2=1 if hp==1 & hp[_n-1]==1 & pid[_n-1]==pid	& age>17 & age[_n-1]>17
bysort id (waveb): replace sample2=1 if hp==1 & hp[_n+1]==1 & pid[_n+1]==pid	& age>17 & age[_n+1]>17 & sample2[_n+1]==1

l id if pid==. & sample2==1		

drop if sample2==0

cap drop pynrpid
bysort pid (wave): gen pynrpid = _n  
cap drop pycountpid
bysort pid: gen pycountpid = _N 	
tab pycountpid, m 	

bysort id: gen pycount = _N 	
tab pycount		


*** Generate variables

** Subjective instability of relationship
egen instab=anycount(pa26 pa27 pa28), values(1)
egen help=anymatch(pa26 pa27 pa28), values(-7/-1)
replace instab=. if help==1
drop help
tab instab, m
recode instab (1/3=1)

gen diffinstab=.
bysort id (waveb): replace diffinstab=0 if instab==instab[_n-1] 		& pid==pid[_n-1] & (!inlist(instab,.a,.) & !inlist(instab[_n-1],.a,.))
bysort id (waveb): replace diffinstab=0 if instab==0 & instab[_n-1]==1  & pid==pid[_n-1] 
bysort id (waveb): replace diffinstab=1 if instab==1 & instab[_n-1]==0  & pid==pid[_n-1] 
lab var diffinstab "Change to relationship instability"

tab waveb diffinstab, m


** Cohabiting & LAT wave t-1
gen lat=relstatn==2
gen cohab=0
replace cohab=1 if inlist(relstatn, 3,4)

tab lat, m
tab cohab, m
tab lat cohab, m
replace lat=. if lat==0 & cohab==0
replace cohab=. if lat==0 & cohab==0

tab lat relstatn, m
tab cohab relstatn,m 
tab lat cohab, m

** Change employment status between waves t-2 and t-1
cap drop pynr
bysort id (wave): gen pynr = _n   				

drop changework
gen changework=.
bysort id (waveb): replace changework=0 if !inlist(workedu,.,.a) 	& waveb!=1	
bysort id (waveb): replace changework=1 if workedu[_n-1]!=workedu	& pynr!=1 & workedu!=. & workedu[_n-1]!=.


save attrition_restr2, replace


*** Models 8 & 9: Effects of of a change toward relationship instability in wave t-1 on participation in wave t by relationship status

drop if waveb==1		// dependent variables waves 3 to 7 

** Number of missing values 
misschk diffinstab age reldur_y woman cohab kidsalv yeduc10 migstatus house changework moves workedu inr_intim inr_hhinc pct_inr nbitems wave ///
		, gen(miss)

** (8) Cohabiting
logit presponse ///
		diffinstab c.age##c.age reldur_y ///
		kidsalv woman yeduc10 i.migstatus house  i.workedu changework moves ///
		inr_intim inr_hhinc pct_inr  c.nbitems##c.nbitems ib(last).wave  if cohab==1, vce(cluster id)	
margins, dydx(*) post
estimates store cohab

** (9) LAT 
logit presponse ///
		diffinstab c.age##c.age reldur_y ///
		kidsalv woman yeduc10 i.migstatus house i.workedu changework moves ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if lat==1, vce(cluster id)	
margins, dydx(*) post
estimates store LAT

** Figure 3: Effects of of a change toward relationship instability in wave t-1 on participation in wave t by relationship status
coefplot cohab, bylabel("{bf: Cohabiting}")  || LAT,bylabel("{bf: Living Apart Together}") ||, ///
	drop(_cons age age2 reldur_y woman kidsalv yeduc10 *migstatus house *workedu changework ///
			inr_intim inr_hhinc pct_inr nbitems nbitems2 moves *wave) aspectratio(.5)    ///
	xline(0,lwidth(vthin) lcolor(black) lpattern(dash))  byopts(xrescale graphregion(color(white)))  ///
	mcolor(black)  ///
	ciopts(lcolor(black) lwidth(thin)) ///
	subtitle (,  margin(medium) size(medsmall) fcolor(white) lcolor(white)) ///
	xlabel(,labsize(medsmall)) ///
	ylabel(`""' "", labsize(small)) ///
	xlabel(-0.1(0.05)0.1, grid labsize(medsmall)) /// 
	ytitle ("", margin(vsmall))	///
	coeflabel(, wrap(35))	///
	xtitle("Average Marginal Effects of a Change toward Relationship Instability & 95% CI's", margin(medium) size(medsmall)) ///
	graphregion(color(white))
	
	
*** Appendix table A3: Effects of a change toward relationship instability in wave t-1 on participation probability in wave t
esttab 	cohab LAT using "outputpath", ///
		r2 b(3) se(3) label star(+ 0.10 * 0.05 ** 0.01 *** 0.001) ///
		stats(r2_p N, fmt(%9.3f %9.0g) labels(Pseudo R-squared)) ///
		varlabels(_cons Constant) posthead("") ///
		mtitles ("Cohabiting" "LAT") replace

		
*** Models 10-13: Effects of a change toward relationship instability in wave t-1 on contact and cooperation probability in wave t
logit pcontact ///
		diffinstab c.age##c.age kidsalv woman i.migstatus house i.workedu changework moves ib(last).wave if cohab==1, vce (cluster id)
margins, dydx(*) post
estimates store Contact1
	
logit pcontact ///
		diffinstab c.age##c.age kidsalv woman i.migstatus house i.workedu changework moves ib(last).wave if lat==1, vce (cluster id)
margins, dydx(*) post
estimates store Contact2

logit pcoop diffinstab c.age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework  ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohab==1, vce(cluster id)
margins, dydx(*) post
estimates store Cooperation1

logit pcoop diffinstab c.age reldur_y  kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave  if lat==1, vce(cluster id)
margins, dydx(*) post
estimates store Cooperation2

** Figure 4: Effects of a change toward relationship instability in wave t-1 on contact and cooperation probability in wave t by relationship status
coefplot (Contact1) (Cooperation1), bylabel("{bf: Cohabiting}")  || (Contact2)  (Cooperation2), bylabel("{bf: Living Apart Together}") ///
	keep(diffinstab) aspectratio(.5)    ///
	xline(0,lwidth(vthin) lcolor(black) lpattern(dash))  byopts(xrescale graphregion(color(white)))  ///
	subtitle (,  margin(medium) size(medsmall) fcolor(white) lcolor(white)) ///
	xlabel(,labsize(medsmall)) ///
	ylabel(`""' "", labsize(medsmall)) ///
	xlabel(-0.1(0.05)0.1, grid) /// 
	ytitle ("", margin(vsmall))	///
	legend(order(2 4) lab(2 "Dependent Variable: Contact") lab(4 "Dependent Variable: Cooperation") size(medsmall) region(lwidth(vthin))) ///
	mcolor(black)  ///
	ciopts(lcolor(black) lwidth(thin)) ///
	coeflabel(, wrap(35))	///
	xtitle("Average Marginal Effects of a Change toward Relationship Instability & 95% CI's", margin(medsmall) size(medsmall)) ///
	graphregion(color(white))

	
*** Appendix tabel A4: Effects of a change toward relationship instability in wave t-1 on contact and cooperation probability in wave t
esttab 	Contact1 Contact2 Cooperation1 Cooperation2 using "outputpath", ///
		r2 b(3) se(3) label star(+ 0.10 * 0.05 ** 0.01 *** 0.001) ///
		stats(r2_p N, fmt(%9.2f %9.0g) labels(Pseudo R-squared)) ///
		varlabels(_cons Constant) posthead("") ///
		mtitles ("Contact Cohabiting" "Contact LAT" "Cooperation Cohabiting" "Cooperation LAT") replace

	

*** Including multiplicative interaction terms for respondents commitment to the panel study 

*** Cohabiting
logit pcoop i.diffinstab age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohab==1
estimates store null
logit pcoop i.diffinstab##ib(last).wave age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if cohab==1
estimates store full
lrtest null full         

logit pcoop i.diffinstab age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohab==1
fitstat, saving(mod1)            
logit pcoop i.diffinstab##ib(last).wave age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if cohab==1
fitstat, using(mod1)             

logit pcoop i.diffinstab age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if cohab==1, vce(cluster id)
margins ib(last).wave#i.diffinstab              
marginsplot,     title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///  
    title ("Predicted Probabilities by Length of Panel Participation", size(med)) ///
	ytitle("P(Cooperation LAT)", size(med))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                           ///
	graphregion(color(white)) 

logit pcoop i.diffinstab##ib(last).wave age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if cohab==1, vce(cluster id)
contrast diffinstab##wave
margins ib(last).wave#i.diffinstab             		 
marginsplot,   plotopts(connect(i))   title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///   
	ytitle("P (Cooperation)", size(medsmall))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                             ///
	graphregion(color(white)) 
	
	
*** LAT
logit pcoop i.diffinstab age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if lat==1
estimates store null
logit pcoop i.diffinstab##ib(last).wave age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if lat==1
estimates store full
lrtest null full         

logit pcoop i.diffinstab age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if lat==1
fitstat, saving(mod1)            
logit pcoop i.diffinstab##ib(last).wave age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if lat==1
fitstat, using(mod1)             

logit pcoop i.diffinstab age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu changework ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems ib(last).wave if lat==1, vce(cluster id)
margins ib(last).wave#i.diffinstab         
marginsplot,     title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///  
    title ("Predicted Probabilities by Length of Panel Participation", size(med)) ///
	ytitle("P(Cooperation LAT)", size(med))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                           ///
	graphregion(color(white)) 

logit pcoop i.diffinstab##ib(last).wave age reldur_y kidsalv woman yeduc10 i.migstatus i.workedu ///
		inr_intim inr_hhinc pct_inr c.nbitems##c.nbitems if lat==1, vce(cluster id)
contrast diffinstab##wave
margins ib(last).wave#i.diffinstab             	
marginsplot,   plotopts(connect(i))   title("")                            ///
   plot1opts(connect(i) mcolor(gs9)) ci1opts (lcolor(gs9))                         ///
   plot2opts(connect(i) mcolor(gs3)) ciopts (lcolor(gs3))        ///   
	ytitle("P (Cooperation)", size(medsmall))                              ///  
	ylabel(0(0.2)1, format(%9.1f) labsize(medsmall) angle(horizontal) grid) ///
	xlabel(,labsize(medsmall)) ///
	xtitle("", )             /// 
	legend(bmargin(medsmall) margin(tiny) row(2) order(1 2)  lab(1 "No Separation")        ///
          lab(2 "Separation")  size(med))                             ///
	graphregion(color(white)) 
